
package apps.conf;

import cnrg.itx.ds.*;
import cnrg.itx.datax.*;

import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.*;


public class ConfUI extends WindowAdapter implements ActionListener, ItemListener, Observer {
	
	private Conference conf = null;
	
	private JTextField inviteTextField = null;
	
	private JFrame frame = null;
	
	private JScrollPane partScroll = null;
	
	private JList partList = null;
	
	private JCheckBox listenCheckBox = null;
	
	private boolean listenCheckState = false;
	
	private Login loginDialog = null;
	
	private String username = "";
	private String pass = "";
	private String topic = "";
	
	public static void main(String args[]){	
	
		ConfUI ui = new ConfUI();
	}
	
	
	
	
	public ConfUI() {
		
		loginDialog = new Login(this);
		
		loginDialog.present();
	}
	
	
	
	
	
	public void buildMainUI() {
		conf = new Conference(username,pass,topic);	
		
		try {
			conf.open();
		} catch (DataException e) {
			System.exit(1);
		}
		
		Dimension buttonSize = new Dimension(80,25);
		
		try {
		    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
		} catch (Exception e) { }
		
		//WindowHandler handler = new WindowHandler(this);
		
		frame = new JFrame("Conference");
		frame.setLocation(500,300);
		frame.setSize(400,400);
		frame.setResizable(false);
		
		//build quit button
		JButton quitButton = new JButton("Quit");
		quitButton.setToolTipText("Disconnects all participants and exits the application"); 
		quitButton.addActionListener(this);
		
		//Build Add Participant pane
		JPanel addPane = new JPanel();
		
		addPane.setLayout(new BoxLayout(addPane,BoxLayout.Y_AXIS));
		
		addPane.setBorder(BorderFactory.createTitledBorder(
														   BorderFactory.createEtchedBorder(Color.white,Color.black),"Add Participant:"));
		
				//Build invite pane
		
				JPanel invitePane = new JPanel();
				
					
		
				//Build invite button
				JButton inviteButton = new JButton("Invite");
				inviteButton.setMinimumSize(buttonSize);
				inviteButton.setPreferredSize(buttonSize);
				inviteButton.setMaximumSize(buttonSize);
				inviteButton.setToolTipText("Invites the specified participant to the conference");
				inviteButton.addActionListener(this);
				
				inviteTextField = new JTextField("jdb30@cornell.edu",25);
	
				invitePane.add(inviteTextField);
				invitePane.add(inviteButton);
				
			//Build listen for calls checkbox
			listenCheckBox = new JCheckBox("Allow participants to dial in", listenCheckState);
			listenCheckBox.setToolTipText("When checked, users dialing the conference will be added");
			listenCheckBox.addItemListener(this);
		
		
		addPane.add(invitePane);
		//addPane.add(Box.createRigidArea(new Dimension(0,5)));
		addPane.add(listenCheckBox);
		addPane.add(Box.createRigidArea(new Dimension(0,3)));
		addPane.setPreferredSize(new Dimension(200,85));
		
		
		
		
		//Build Participant pane
		JPanel partPane = new JPanel();
		
		partPane.setBorder(BorderFactory.createTitledBorder(
															BorderFactory.createEtchedBorder(Color.white,Color.black),"Participants:"));
		
		
			//Build the participant list
			partList = new JList(conf.getParticipants());
			partList.setPrototypeCellValue("jdb30@cornell.edu        \tJames Barabas");        
			partScroll = new JScrollPane(partList,
										 JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
										 JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			partScroll.setMinimumSize(new Dimension(200,100));
			partScroll.setPreferredSize(new Dimension(200,100));
			partScroll.setAlignmentX(JScrollPane.LEFT_ALIGNMENT);
			
			JPanel partButtonPane = new JPanel();

			
				
				//Build the drop button
				JButton dropButton = new JButton("Drop");
				dropButton.setMinimumSize(buttonSize);
				dropButton.setPreferredSize(buttonSize);
				dropButton.setMaximumSize(buttonSize);
				dropButton.setToolTipText("removes the selected participant from the conference");
				dropButton.addActionListener(this);
					
			
			partButtonPane.add(dropButton);
			//partButtonPane.add(Box.createRigidArea(new Dimension(0,20)));
			//partButtonPane.add(listenButton);
			partButtonPane.setLayout(new BoxLayout(partButtonPane,BoxLayout.Y_AXIS));
												
				
			//assemble particicpant pane
			partPane.add(partScroll);
			partPane.add(partButtonPane);
		
		//Build bottomPane
		JPanel bottomPane = new JPanel();
		bottomPane.setLayout(new BoxLayout(bottomPane,BoxLayout.X_AXIS));
		bottomPane.add(Box.createHorizontalGlue());
		bottomPane.add(quitButton);
		bottomPane.setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
		
		//Create main pane
		JPanel mainPane = new JPanel();
		mainPane.add(addPane);
		mainPane.add(partPane);
		mainPane.add(bottomPane);
		mainPane.setLayout(new BoxLayout(mainPane,BoxLayout.Y_AXIS));
		
		//put mainPane in frame
		frame.getContentPane().add(mainPane,BorderLayout.CENTER);
		
		//add handler for close/minimize etc.
		frame.addWindowListener(this);
		
		frame.pack();
		frame.setVisible(true);
		frame.toFront();

		
		
	}
	/**
	 * Hook for the login dialog to specify results.
	 */
	public void login(String user, String pass, String topic) {
		this.username = user;
		this.pass = pass;
		this.topic = topic;
	}

	public Conference getConference() {
		return this.conf;
	}
	
	public String getInviteContents() {
		return inviteTextField.getText();
	}
	
	public JFrame getFrame() {
		return frame;
	}
	

	
	




	
	public void windowClosed(WindowEvent we) {
		close();
	}
	
	public void windowClosing(WindowEvent we) {
		close();
		
	}
	
	public void actionPerformed(ActionEvent ae) {
	
		String name = ae.getActionCommand();
		
		//QUIT
		if (name.equals("Quit")) {
			close();
		
		//INVITE
		} else if (name.equals("Invite")){
			try {
				this.getConference().add(inviteTextField.getText());
			} catch (Exception e) {
				e.printStackTrace();
			}
		
		//DROP
		} else if (name.equals("Drop")) {
			try {
				Object[] toDrop = partList.getSelectedValues();
				for (int i = 0;i<toDrop.length;i++) {
					this.getConference().remove((ConnectionManager)toDrop[i]);
				}
			} catch (ArrayIndexOutOfBoundsException e) {
				System.out.println("No selection to drop...");
			}
		//LOGIN
		} else if (ae.getSource().equals(loginDialog.getLoginButton())) {
			loginDialog.sendLogin();
			try {
				DirectoryService ds = new DirectoryService();
				ds.declareIdentity(new UserID(this.username),new Password(this.pass));
			} catch (Exception e) {
				loginDialog.fail();
				return;
			}
			
			loginDialog.setVisible(false);
			this.buildMainUI();
			
		

		
		
		
										  
										  
		} else System.out.println("Action: "+ae.getActionCommand());
		}
	
	
	
	
	public void itemStateChanged(ItemEvent ie) {
		Vector parts = conf.getParticipants();
		if (ie.getItemSelectable() == listenCheckBox) {
			listenCheckState = !listenCheckState;
			if (!listenCheckState) {
				for (Enumeration e = parts.elements();e.hasMoreElements();) { 
					ConnectionManager cm =(ConnectionManager)e.nextElement();
					if (cm.toString().equals("Waiting for call")) { //HACK: yes, this is a cheap way of telling if it is a listener
						conf.remove(cm);
					}
				}
			}else {
				conf.addAcceptor();
			}
		}
	}
	
	private void close() {
		
		this.conf.close();
		frame.setVisible(false);
		try {
			Thread.currentThread().sleep(1000);
		}catch (InterruptedException e) {}
		System.exit(0);
	}
	
	public void update(Observable obs, Object o) {
		//if (obs.equals(conf.getParticipants())) {
			partList.revalidate();
			partScroll.repaint();
		//}
	}
	/* ***** Code for ListDataListener *****************/
	
	// For now, repaint whole list ctrl. when the list changes.
	
	public void contentsChanged(ListDataEvent lde) {
		partScroll.repaint();
	}
	public void intervalAdded(ListDataEvent lde) {
		partScroll.repaint();
	}
	public void intervalRemoved(ListDataEvent lde) {
		partScroll.repaint();
	}
}


